/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpContext;
import com.quantumdata.ftp.FtpControlSocket;
import com.quantumdata.ftp.FtpInterpret;
import com.quantumdata.std.IQDConsole;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

final class FtpDataSocket {
    private ServerSocket m_dataserver = null;
    private Socket m_data = null;
    private FtpContext m_context = null;
    private FtpControlSocket m_control = null;
    static int g_id = 0;

    FtpDataSocket(Ftp ftp) throws IOException {
        if (!ftp.isConnected()) {
            throw new IOException("Data: CreateSocket, No Connection!");
        }
        this.m_control = ftp.getControl();
        this.m_context = ftp.getContext();
    }

    public FtpContext getContext() {
        return this.m_context;
    }

    String getConnect(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("Null Reply!\n");
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n != -1 && n2 != -1 && n < n2) {
            return string.substring(n + 1, n2);
        }
        throw new NumberFormatException("Invalid Reply!\n" + string);
    }

    String getConnectAddress(String string) throws NumberFormatException {
        int n = -1;
        for (int i = 0; i < 4; ++i) {
            if ((n = string.indexOf(44, n + 1)) != -1) continue;
            throw new NumberFormatException("Misformated Reply! " + i + ":" + n + " " + string);
        }
        return string.substring(0, n).replace(',', '.');
    }

    int getConnectPort(String string) throws NumberFormatException, NoSuchElementException {
        int n = -1;
        for (int i = 0; i < 4; ++i) {
            if ((n = string.indexOf(44, n + 1)) != -1) continue;
            throw new NumberFormatException("Misformated Reply! " + i + ":" + n + " " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), ",");
        return Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
    }

    void openPassiveDataSocket(String string, char c) throws IOException {
        int n;
        String string2;
        if (!this.m_control.isConnected()) {
            throw new IOException("Data: OpenSocket, No Connection!");
        }
        try {
            this.m_control.executeCommand("TYPE " + c);
            this.m_control.executeCommand("PASV");
            String string3 = this.getConnect(this.m_control.replyOfCommand());
            string2 = this.getConnectAddress(string3);
            n = this.getConnectPort(string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IOException("Data: OpenSocket, Invalid Format!\n" + noSuchElementException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Data: OpenSocket, Invalid Format!\n" + numberFormatException);
        }
        catch (SocketException socketException) {
            throw new IOException("Data: OpenSocket, Socket Error!\n" + socketException);
        }
        catch (IOException iOException) {
            throw new IOException("Data: OpenSocket, IO Error!\n" + iOException);
        }
        catch (Exception exception) {
            throw new IOException("Data: OpenSocket, Permission Denied?\n" + exception);
        }
        int n2 = 0;
        while (true) {
            try {
                this.m_data = new Socket(string2, n);
                this.m_data.setSoTimeout(60000);
            }
            catch (Exception exception) {
                if (++n2 == 3) {
                    throw new IOException("OpenSocket: " + exception);
                }
                IQDConsole iQDConsole = this.m_context.getConsole();
                if (iQDConsole == null) continue;
                String string4 = "*** Data Connect Failed: Retrying...(" + n2 + ")";
                iQDConsole.println(string4);
                continue;
            }
            break;
        }
        try {
            if (!this.m_control.executeCommand(string)) {
                throw new IOException(this.m_control.replyOfCommand());
            }
        }
        catch (Exception exception) {
            throw new IOException("Execute Cmd: " + exception);
        }
    }

    String getConnect() throws UnknownHostException {
        short s = (short)this.m_dataserver.getLocalPort();
        return InetAddress.getLocalHost().getHostAddress().replace('.', ',') + "," + s / 256 + "," + s % 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openActiveDataSocket(String string, char c) throws IOException {
        block9: {
            if (this.m_control.isConnected()) {
                try {
                    this.m_control.executeCommand("TYPE " + c);
                    this.m_dataserver = new ServerSocket(0);
                    this.m_dataserver.setSoTimeout(20000);
                    this.m_control.executeCommand("PORT " + this.getConnect());
                    FtpControlSocket ftpControlSocket = this.m_control;
                    synchronized (ftpControlSocket) {
                        this.m_control.writeCommand(string);
                        this.m_data = this.m_dataserver.accept();
                        this.m_data.setSoTimeout(60000);
                        if (!this.m_control.completeCommand(FtpInterpret.getReplies(string))) {
                            throw new IOException(this.m_control.replyOfCommand());
                        }
                        break block9;
                    }
                }
                catch (SocketException socketException) {
                    throw new IOException("Data: OpenSocket, Socket Error!\n" + socketException);
                }
                catch (IOException iOException) {
                    throw new IOException("Data: OpenSocket, IO Error!\n" + iOException);
                }
                catch (Exception exception) {
                    throw new IOException("Data: OpenSocket, Permission Denied!\n" + exception);
                }
            }
            throw new IOException("Data: OpenSocket, No Connection!");
        }
    }

    void openDataSocket(String string, char c) throws IOException {
        if (this.m_context.getActiveSocketMode()) {
            this.openActiveDataSocket(string, c);
        } else {
            this.openPassiveDataSocket(string, c);
        }
    }

    InputStream getInputStream(String string, char c) throws IOException {
        if (this.m_data == null) {
            this.openDataSocket(string, c);
        }
        return this.m_data.getInputStream();
    }

    OutputStream getOutputStream(String string, char c) throws IOException {
        if (this.m_data == null) {
            this.openDataSocket(string, c);
        }
        return this.m_data.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void close() throws IOException {
        block9: {
            try {
                if (this.m_data != null) {
                    this.m_data.close();
                }
                Object var2_1 = null;
                this.m_data = null;
                if (!this.m_control.isConnected()) throw new IOException("Data: CloseSocket, No Connection!");
                if (this.m_control.completeCommand(FtpInterpret.getReplies("data-done"))) break block9;
                this.m_control.executeCommand("ABOR");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.m_data = null;
                if (!this.m_control.isConnected()) throw new IOException("Data: CloseSocket, No Connection!");
                if (!this.m_control.completeCommand(FtpInterpret.getReplies("data-done"))) {
                    this.m_control.executeCommand("ABOR");
                    throw new IOException("Data: CloseSocket, Transfer Aborted!");
                }
                try {
                    if (this.m_dataserver == null) throw throwable;
                    this.m_dataserver.close();
                    throw throwable;
                }
                finally {
                    this.m_dataserver = null;
                }
            }
            throw new IOException("Data: CloseSocket, Transfer Aborted!");
        }
        try {
            if (this.m_dataserver == null) return;
            this.m_dataserver.close();
            return;
        }
        finally {
            this.m_dataserver = null;
        }
    }
}

